/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.functions;

import java.util.Enumeration;
import java.util.Vector;
import weka.classifiers.AbstractClassifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Option;
import weka.core.OptionHandler;
import weka.core.RevisionUtils;
import weka.core.SelectedTag;
import weka.core.Tag;
import weka.core.Utils;
import weka.core.WeightedInstancesHandler;
import weka.core.matrix.Matrix;
import weka.filters.Filter;
import weka.filters.supervised.attribute.NominalToBinary;
import weka.filters.unsupervised.attribute.ReplaceMissingValues;

public class LinearRegression
extends AbstractClassifier
implements OptionHandler,
WeightedInstancesHandler {
    static final long serialVersionUID = -3364580862046573747L;
    protected double[] m_Coefficients;
    protected boolean[] m_SelectedAttributes;
    protected Instances m_TransformedData;
    protected ReplaceMissingValues m_MissingFilter;
    protected NominalToBinary m_TransformFilter;
    protected double m_ClassStdDev;
    protected double m_ClassMean;
    protected int m_ClassIndex;
    protected double[] m_Means;
    protected double[] m_StdDevs;
    protected int m_AttributeSelection;
    public static final int SELECTION_M5 = 0;
    public static final int SELECTION_NONE = 1;
    public static final int SELECTION_GREEDY = 2;
    public static final Tag[] TAGS_SELECTION = new Tag[]{new Tag(1, "No attribute selection"), new Tag(0, "M5 method"), new Tag(2, "Greedy method")};
    protected boolean m_EliminateColinearAttributes = true;
    protected boolean m_checksTurnedOff = false;
    protected double m_Ridge = 1.0E-8;
    protected boolean m_Minimal = false;
    protected boolean m_ModelBuilt = false;

    public String globalInfo() {
        return "Class for using linear regression for prediction. Uses the Akaike criterion for model selection, and is able to deal with weighted instances.";
    }

    @Override
    public Capabilities getCapabilities() {
        Capabilities result = super.getCapabilities();
        result.disableAll();
        result.enable(Capabilities.Capability.NOMINAL_ATTRIBUTES);
        result.enable(Capabilities.Capability.NUMERIC_ATTRIBUTES);
        result.enable(Capabilities.Capability.DATE_ATTRIBUTES);
        result.enable(Capabilities.Capability.MISSING_VALUES);
        result.enable(Capabilities.Capability.NUMERIC_CLASS);
        result.enable(Capabilities.Capability.DATE_CLASS);
        result.enable(Capabilities.Capability.MISSING_CLASS_VALUES);
        return result;
    }

    @Override
    public void buildClassifier(Instances data) throws Exception {
        this.m_ModelBuilt = false;
        if (!this.m_checksTurnedOff) {
            this.getCapabilities().testWithFail(data);
            data = new Instances(data);
            data.deleteWithMissingClass();
        }
        if (!this.m_checksTurnedOff) {
            this.m_TransformFilter = new NominalToBinary();
            this.m_TransformFilter.setInputFormat(data);
            data = Filter.useFilter(data, this.m_TransformFilter);
            this.m_MissingFilter = new ReplaceMissingValues();
            this.m_MissingFilter.setInputFormat(data);
            data = Filter.useFilter(data, this.m_MissingFilter);
            data.deleteWithMissingClass();
        } else {
            this.m_TransformFilter = null;
            this.m_MissingFilter = null;
        }
        this.m_ClassIndex = data.classIndex();
        this.m_TransformedData = data;
        this.m_SelectedAttributes = new boolean[data.numAttributes()];
        int i = 0;
        while (i < data.numAttributes()) {
            if (i != this.m_ClassIndex) {
                this.m_SelectedAttributes[i] = true;
            }
            ++i;
        }
        this.m_Coefficients = null;
        this.m_Means = new double[data.numAttributes()];
        this.m_StdDevs = new double[data.numAttributes()];
        int j = 0;
        while (j < data.numAttributes()) {
            if (j != data.classIndex()) {
                this.m_Means[j] = data.meanOrMode(j);
                this.m_StdDevs[j] = Math.sqrt(data.variance(j));
                if (this.m_StdDevs[j] == 0.0) {
                    this.m_SelectedAttributes[j] = false;
                }
            }
            ++j;
        }
        this.m_ClassStdDev = Math.sqrt(data.variance(this.m_TransformedData.classIndex()));
        this.m_ClassMean = data.meanOrMode(this.m_TransformedData.classIndex());
        this.findBestModel();
        if (this.m_Minimal) {
            this.m_TransformedData = null;
            this.m_Means = null;
            this.m_StdDevs = null;
        } else {
            this.m_TransformedData = new Instances(data, 0);
        }
        this.m_ModelBuilt = true;
    }

    @Override
    public double classifyInstance(Instance instance) throws Exception {
        Instance transformedInstance = instance;
        if (!this.m_checksTurnedOff) {
            this.m_TransformFilter.input(transformedInstance);
            this.m_TransformFilter.batchFinished();
            transformedInstance = this.m_TransformFilter.output();
            this.m_MissingFilter.input(transformedInstance);
            this.m_MissingFilter.batchFinished();
            transformedInstance = this.m_MissingFilter.output();
        }
        return this.regressionPrediction(transformedInstance, this.m_SelectedAttributes, this.m_Coefficients);
    }

    public String toString() {
        if (!this.m_ModelBuilt) {
            return "Linear Regression: No model built yet.";
        }
        if (this.m_Minimal) {
            return "Linear Regression: Model built.";
        }
        try {
            StringBuilder text = new StringBuilder();
            int column = 0;
            boolean first = true;
            text.append("\nLinear Regression Model\n\n");
            text.append(String.valueOf(this.m_TransformedData.classAttribute().name()) + " =\n\n");
            int i = 0;
            while (i < this.m_TransformedData.numAttributes()) {
                if (i != this.m_ClassIndex && this.m_SelectedAttributes[i]) {
                    if (!first) {
                        text.append(" +\n");
                    } else {
                        first = false;
                    }
                    text.append(String.valueOf(Utils.doubleToString(this.m_Coefficients[column], 12, 4)) + " * ");
                    text.append(this.m_TransformedData.attribute(i).name());
                    ++column;
                }
                ++i;
            }
            text.append(" +\n" + Utils.doubleToString(this.m_Coefficients[column], 12, 4));
            return text.toString();
        }
        catch (Exception e) {
            return "Can't print Linear Regression!";
        }
    }

    @Override
    public Enumeration listOptions() {
        Vector<Option> newVector = new Vector<Option>();
        newVector.addElement(new Option("\tProduce debugging output.\n\t(default no debugging output)", "D", 0, "-D"));
        newVector.addElement(new Option("\tSet the attribute selection method to use. 1 = None, 2 = Greedy.\n\t(default 0 = M5' method)", "S", 1, "-S <number of selection method>"));
        newVector.addElement(new Option("\tDo not try to eliminate colinear attributes.\n", "C", 0, "-C"));
        newVector.addElement(new Option("\tSet ridge parameter (default 1.0e-8).\n", "R", 1, "-R <double>"));
        newVector.addElement(new Option("\tConserve memory, don't keep dataset header and means/stdevs.\n\tModel cannot be printed out if this option is enabled.\t(default: keep data)", "minimal", 0, "-minimal"));
        return newVector.elements();
    }

    @Override
    public void setOptions(String[] options) throws Exception {
        String selectionString = Utils.getOption('S', options);
        if (selectionString.length() != 0) {
            this.setAttributeSelectionMethod(new SelectedTag(Integer.parseInt(selectionString), TAGS_SELECTION));
        } else {
            this.setAttributeSelectionMethod(new SelectedTag(0, TAGS_SELECTION));
        }
        String ridgeString = Utils.getOption('R', options);
        if (ridgeString.length() != 0) {
            this.setRidge(new Double(ridgeString));
        } else {
            this.setRidge(1.0E-8);
        }
        this.setDebug(Utils.getFlag('D', options));
        this.setEliminateColinearAttributes(!Utils.getFlag('C', options));
        this.setMinimal(Utils.getFlag("minimal", options));
    }

    public double[] coefficients() {
        double[] coefficients = new double[this.m_SelectedAttributes.length + 1];
        int counter = 0;
        int i = 0;
        while (i < this.m_SelectedAttributes.length) {
            if (this.m_SelectedAttributes[i] && i != this.m_ClassIndex) {
                coefficients[i] = this.m_Coefficients[counter++];
            }
            ++i;
        }
        coefficients[this.m_SelectedAttributes.length] = this.m_Coefficients[counter];
        return coefficients;
    }

    @Override
    public String[] getOptions() {
        Vector<String> result = new Vector<String>();
        result.add("-S");
        result.add("" + this.getAttributeSelectionMethod().getSelectedTag().getID());
        if (this.getDebug()) {
            result.add("-D");
        }
        if (!this.getEliminateColinearAttributes()) {
            result.add("-C");
        }
        result.add("-R");
        result.add("" + this.getRidge());
        if (this.getMinimal()) {
            result.add("-minimal");
        }
        return result.toArray(new String[result.size()]);
    }

    public String ridgeTipText() {
        return "The value of the Ridge parameter.";
    }

    public double getRidge() {
        return this.m_Ridge;
    }

    public void setRidge(double newRidge) {
        this.m_Ridge = newRidge;
    }

    public String eliminateColinearAttributesTipText() {
        return "Eliminate colinear attributes.";
    }

    public boolean getEliminateColinearAttributes() {
        return this.m_EliminateColinearAttributes;
    }

    public void setEliminateColinearAttributes(boolean newEliminateColinearAttributes) {
        this.m_EliminateColinearAttributes = newEliminateColinearAttributes;
    }

    public int numParameters() {
        return this.m_Coefficients.length - 1;
    }

    public String attributeSelectionMethodTipText() {
        return "Set the method used to select attributes for use in the linear regression. Available methods are: no attribute selection, attribute selection using M5's method (step through the attributes removing the one with the smallest standardised coefficient until no improvement is observed in the estimate of the error given by the Akaike information criterion), and a greedy selection using the Akaike information metric.";
    }

    public void setAttributeSelectionMethod(SelectedTag method) {
        if (method.getTags() == TAGS_SELECTION) {
            this.m_AttributeSelection = method.getSelectedTag().getID();
        }
    }

    public SelectedTag getAttributeSelectionMethod() {
        return new SelectedTag(this.m_AttributeSelection, TAGS_SELECTION);
    }

    public String minimalTipText() {
        return "If enabled, dataset header, means and stdevs get discarded to conserve memory; also, the model cannot be printed out.";
    }

    public void setMinimal(boolean value) {
        this.m_Minimal = value;
    }

    public boolean getMinimal() {
        return this.m_Minimal;
    }

    public void turnChecksOff() {
        this.m_checksTurnedOff = true;
    }

    public void turnChecksOn() {
        this.m_checksTurnedOff = false;
    }

    protected boolean deselectColinearAttributes(boolean[] selectedAttributes, double[] coefficients) {
        double maxSC = 1.5;
        int maxAttr = -1;
        int coeff = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                double SC = Math.abs(coefficients[coeff] * this.m_StdDevs[i] / this.m_ClassStdDev);
                if (SC > maxSC) {
                    maxSC = SC;
                    maxAttr = i;
                }
                ++coeff;
            }
            ++i;
        }
        if (maxAttr >= 0) {
            selectedAttributes[maxAttr] = false;
            if (this.m_Debug) {
                System.out.println("Deselected colinear attribute:" + (maxAttr + 1) + " with standardised coefficient: " + maxSC);
            }
            return true;
        }
        return false;
    }

    protected void findBestModel() throws Exception {
        int numInstances = this.m_TransformedData.numInstances();
        if (this.m_Debug) {
            System.out.println(new Instances(this.m_TransformedData, 0).toString());
        }
        do {
            this.m_Coefficients = this.doRegression(this.m_SelectedAttributes);
        } while (this.m_EliminateColinearAttributes && this.deselectColinearAttributes(this.m_SelectedAttributes, this.m_Coefficients));
        int numAttributes = 1;
        int i = 0;
        while (i < this.m_SelectedAttributes.length) {
            if (this.m_SelectedAttributes[i]) {
                ++numAttributes;
            }
            ++i;
        }
        double fullMSE = this.calculateSE(this.m_SelectedAttributes, this.m_Coefficients);
        double akaike = numInstances - numAttributes + 2 * numAttributes;
        if (this.m_Debug) {
            System.out.println("Initial Akaike value: " + akaike);
        }
        int currentNumAttributes = numAttributes;
        switch (this.m_AttributeSelection) {
            case 2: {
                boolean improved;
                do {
                    boolean[] currentSelected = (boolean[])this.m_SelectedAttributes.clone();
                    improved = false;
                    --currentNumAttributes;
                    int i2 = 0;
                    while (i2 < this.m_SelectedAttributes.length) {
                        if (currentSelected[i2]) {
                            currentSelected[i2] = false;
                            double[] currentCoeffs = this.doRegression(currentSelected);
                            double currentMSE = this.calculateSE(currentSelected, currentCoeffs);
                            double currentAkaike = currentMSE / fullMSE * (double)(numInstances - numAttributes) + (double)(2 * currentNumAttributes);
                            if (this.m_Debug) {
                                System.out.println("(akaike: " + currentAkaike);
                            }
                            if (currentAkaike < akaike) {
                                if (this.m_Debug) {
                                    System.err.println("Removing attribute " + (i2 + 1) + " improved Akaike: " + currentAkaike);
                                }
                                improved = true;
                                akaike = currentAkaike;
                                System.arraycopy(currentSelected, 0, this.m_SelectedAttributes, 0, this.m_SelectedAttributes.length);
                                this.m_Coefficients = currentCoeffs;
                            }
                            currentSelected[i2] = true;
                        }
                        ++i2;
                    }
                } while (improved);
                break;
            }
            case 0: {
                boolean improved;
                do {
                    improved = false;
                    --currentNumAttributes;
                    double minSC = 0.0;
                    int minAttr = -1;
                    int coeff = 0;
                    int i3 = 0;
                    while (i3 < this.m_SelectedAttributes.length) {
                        if (this.m_SelectedAttributes[i3]) {
                            double SC = Math.abs(this.m_Coefficients[coeff] * this.m_StdDevs[i3] / this.m_ClassStdDev);
                            if (coeff == 0 || SC < minSC) {
                                minSC = SC;
                                minAttr = i3;
                            }
                            ++coeff;
                        }
                        ++i3;
                    }
                    if (minAttr < 0) continue;
                    this.m_SelectedAttributes[minAttr] = false;
                    double[] currentCoeffs = this.doRegression(this.m_SelectedAttributes);
                    double currentMSE = this.calculateSE(this.m_SelectedAttributes, currentCoeffs);
                    double currentAkaike = currentMSE / fullMSE * (double)(numInstances - numAttributes) + (double)(2 * currentNumAttributes);
                    if (this.m_Debug) {
                        System.out.println("(akaike: " + currentAkaike);
                    }
                    if (currentAkaike < akaike) {
                        if (this.m_Debug) {
                            System.err.println("Removing attribute " + (minAttr + 1) + " improved Akaike: " + currentAkaike);
                        }
                        improved = true;
                        akaike = currentAkaike;
                        this.m_Coefficients = currentCoeffs;
                        continue;
                    }
                    this.m_SelectedAttributes[minAttr] = true;
                } while (improved);
                break;
            }
        }
    }

    protected double calculateSE(boolean[] selectedAttributes, double[] coefficients) throws Exception {
        double mse = 0.0;
        int i = 0;
        while (i < this.m_TransformedData.numInstances()) {
            double prediction = this.regressionPrediction(this.m_TransformedData.instance(i), selectedAttributes, coefficients);
            double error = prediction - this.m_TransformedData.instance(i).classValue();
            mse += error * error;
            ++i;
        }
        return mse;
    }

    protected double regressionPrediction(Instance transformedInstance, boolean[] selectedAttributes, double[] coefficients) throws Exception {
        double result = 0.0;
        int column = 0;
        int j = 0;
        while (j < transformedInstance.numAttributes()) {
            if (this.m_ClassIndex != j && selectedAttributes[j]) {
                result += coefficients[column] * transformedInstance.value(j);
                ++column;
            }
            ++j;
        }
        return result += coefficients[column];
    }

    protected double[] doRegression(boolean[] selectedAttributes) throws Exception {
        if (this.m_Debug) {
            System.out.print("doRegression(");
            int i = 0;
            while (i < selectedAttributes.length) {
                System.out.print(" " + selectedAttributes[i]);
                ++i;
            }
            System.out.println(" )");
        }
        int numAttributes = 0;
        int i = 0;
        while (i < selectedAttributes.length) {
            if (selectedAttributes[i]) {
                ++numAttributes;
            }
            ++i;
        }
        Matrix independent = null;
        Matrix dependent = null;
        if (numAttributes > 0) {
            independent = new Matrix(this.m_TransformedData.numInstances(), numAttributes);
            dependent = new Matrix(this.m_TransformedData.numInstances(), 1);
            int i2 = 0;
            while (i2 < this.m_TransformedData.numInstances()) {
                Instance inst = this.m_TransformedData.instance(i2);
                double sqrt_weight = Math.sqrt(inst.weight());
                int column = 0;
                int j = 0;
                while (j < this.m_TransformedData.numAttributes()) {
                    if (j == this.m_ClassIndex) {
                        dependent.set(i2, 0, inst.classValue() * sqrt_weight);
                    } else if (selectedAttributes[j]) {
                        double value = inst.value(j) - this.m_Means[j];
                        if (!this.m_checksTurnedOff) {
                            value /= this.m_StdDevs[j];
                        }
                        independent.set(i2, column, value * sqrt_weight);
                        ++column;
                    }
                    ++j;
                }
                ++i2;
            }
        }
        double[] coefficients = new double[numAttributes + 1];
        if (numAttributes > 0) {
            double[] coeffsWithoutIntercept = independent.regression(dependent, this.m_Ridge).getCoefficients();
            System.arraycopy(coeffsWithoutIntercept, 0, coefficients, 0, numAttributes);
        }
        coefficients[numAttributes] = this.m_ClassMean;
        int column = 0;
        int i3 = 0;
        while (i3 < this.m_TransformedData.numAttributes()) {
            if (i3 != this.m_TransformedData.classIndex() && selectedAttributes[i3]) {
                if (!this.m_checksTurnedOff) {
                    int n = column;
                    coefficients[n] = coefficients[n] / this.m_StdDevs[i3];
                }
                int n = coefficients.length - 1;
                coefficients[n] = coefficients[n] - coefficients[column] * this.m_Means[i3];
                ++column;
            }
            ++i3;
        }
        return coefficients;
    }

    @Override
    public String getRevision() {
        return RevisionUtils.extract("$Revision: 9768 $");
    }

    public static void main(String[] argv) {
        LinearRegression.runClassifier(new LinearRegression(), argv);
    }
}

